<?php

use Illuminate\Support\Facades\Route;

//use App\Http\Controllers\Auth\UserVerificationEmail;
use App\Http\Controllers\Auth\ActivacionCuentaController;
use App\Http\Controllers\Auth\RecuperacionContrasenaController;
use App\Http\Controllers\Auth\CambioCodigoBloqueoController;

Route::get('/', function () {
    return redirect('https://hospitalia-test.synergiasa.com');
});

Route::get('/activeAccount/{code}', [ActivacionCuentaController::class, 'mostrarInterfazActivacionInicial'])->name('active.form');
Route::get('/activeAccount/{code}/{status}', [ActivacionCuentaController::class, 'mostrarInterfazActivacion'])->name('active.form2');
Route::put('/activeAccount/{email}/{code}', [ActivacionCuentaController::class, 'activarCuenta'])->name('active.account');

Route::get('/passwordReset/{code}', [RecuperacionContrasenaController::class, 'mostrarInterfazRecuperacionInicial'])->name('password.form');
Route::get('/passwordReset/{code}/{status}', [RecuperacionContrasenaController::class, 'mostrarInterfazRecuperacion'])->name('password.form2');
Route::put('/passwordReset/{email}/{code}', [RecuperacionContrasenaController::class, 'reestablecerContrasena'])->name('password.change');

Route::get('/lockCodeChange/{code}', [CambioCodigoBloqueoController::class, 'activarCambioCodigoBloqueo'])->name('lockCode.change');
