<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reps_prestadores', function (Blueprint $table) {
            $table->string('rpr_pk_id', 50);
            $table->integer('dep_fk_id');
            $table->integer('mun_fk_id');
            $table->string('rpr_nit', 100);
            $table->string('rpr_razon_social', 1000);
            $table->string('rpr_rep_legal', 1000)->nullable();
            $table->string('rpr_correo', 1000)->nullable();
            $table->string('rpr_direccion', 1000)->nullable();
            $table->string('rpr_telefono', 1000)->nullable();
            $table->string('rpr_no_sede_principal', 10)->nullable();
            $table->boolean('rpr_activo')->default(true);

            $table->primary('rpr_pk_id');

            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos');
            $table->foreign('mun_fk_id')->references('mun_pk_id')->on('municipios');

            $table->index(['dep_fk_id', 'mun_fk_id']);
            $table->index('mun_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reps_prestadores');
    }
};
