<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NotificacionVisitaRias extends Mailable
{
    use Queueable, SerializesModels;

    public $prestador;
    public $sede;
    public $codigo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($prestador, $sede, $codigo)
    {
        $this->prestador = $prestador;
        $this->sede = $sede;
        $this->codigo = $codigo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('administrador@tguia-iv')
                    ->view('mail.notificacionVisitasRias')
                    ->text('mail.notificacionVisitasRias_plain')
                    ->with(
                        [
                            'prestador' => $this->prestador,
                            'sede' => $this->sede,
                            'codigo' => $this->codigo
                        ]
                    );
    }
}
