<?php

namespace App\Http\Services;

class Combinations
{
    public function combine($elements, $length)
    {
        $combinations = array();
        $stack = array();

        // startup
        array_push($stack, array(
            'store' => array(),
            'options' => $elements,
        ));

        while (true) {
            // pop a item
            $item = array_pop($stack);

            // end of stack
            if (!$item) {
                break;
            }

            // valid store
            if ($length <= count($item['store'])) {
                $combinations[] = $item['store'];
                continue;
            }

            // bypass when options are not enough
            if (count($item['store']) + count($item['options']) < $length) {
                continue;
            }

            foreach ($item['options'] as $index => $n) {
                $newStore = $item['store'];
                $newStore[] = $n;

                // every combine can be ordered
                // so accept only options which is greater than store numbers
                $newOptions = array_slice($item['options'], $index + 1);

                // push new items
                array_push($stack, array(
                    'store' => $newStore,
                    'options' => $newOptions,
                ));
            }
        }

        return $combinations;
    }
}