<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\base\User;

use Illuminate\Support\Carbon;

class CambioCodigoBloqueoController extends Controller
{
    public function activarCambioCodigoBloqueo(Request $request, $code) {
        $info = User::where('usu_autorizacion_codigo_bloqueo', $code)->get()->toArray();

        if (count($info) > 0) {
            $plazo = Carbon::now()->addMinutes(5);

            User::where('id', $info[0]['id'])->update([
                'usu_autorizacion_codigo_bloqueo' => null,
                'usu_plazo_cambio_codigo_bloqueo' => $plazo
            ]);

            return view('confirmacionCambioBloqueo');
        }

        return view('denegacionCambioBloqueo');
    }
}
