<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasAPNAtnPreconcepcional;
use App\Models\clientes\HistoricoInsRiasAPNAtnPreconcepcional;

class InstrumentosRiasAPNAtnPreconcepcionalController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)
                                                    ->orderBy('irp_activa', 'desc')
                                                    ->orderBy('irp_pk_id', 'desc')
                                                    ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_apn_atn_preconcepcional\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)->create([
                'irp_version' => $nuevaVersion,
                'irp_comentarios' => $request->irp_comentarios,
                'irp_instrumento' => json_encode($request->irp_instrumento),
                'irp_usu_creacion' => $usuario
            ])->irp_pk_id;

            HistoricoInsRiasAPNAtnPreconcepcional::on($this->cliente)->create([
                'irp_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrp_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)->where('irp_pk_id', $id)->update([
                'irp_comentarios' => $request->irp_comentarios,
                'irp_instrumento' => $request->irp_instrumento
            ]);

            HistoricoInsRiasAPNAtnPreconcepcional::on($this->cliente)->create([
                'irp_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrp_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)
                                                    ->where('irp_activa', true)
                                                    ->pluck('irp_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)->where('irp_pk_id', $idActivo)->update([
                'irp_activa' => false
            ]);

            HistoricoInsRiasAPNAtnPreconcepcional::on($this->cliente)->create([
                'irp_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hrp_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasAPNAtnPreconcepcional::on($this->cliente)->where('irp_pk_id', $id)->update([
                'irp_activa' => true
            ]);

            HistoricoInsRiasAPNAtnPreconcepcional::on($this->cliente)->create([
                'irp_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrp_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasAPNAtnPreconcepcional::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_apn_atn_preconcepcional.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('irp_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
