<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\InstrumentosRiasAPNAtnFamilias;
use App\Models\clientes\HistoricoInsRiasAPNAtnFamilias;

class InstrumentosRiasAPNAtnFamiliasController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerInstrumentos(Request $request) {
        return InstrumentosRiasAPNAtnFamilias::on($this->cliente)
                                            ->orderBy('irf_activa', 'desc')
                                            ->orderBy('irf_pk_id', 'desc')
                                            ->get()->toArray();
    }

    public function crearInstrumento(Request $request) {
        $id = null;
        $nuevaVersion = null;

        DB::connection($this->cliente)->transaction(function() use($request, &$id, &$nuevaVersion) {
            $nuevaVersion = DB::connection($this->cliente)->select(
                'select nextval(\'"'.$this->cliente.'".seq_rias_apn_atn_familias\')'
            )[0]->nextval;

            $usuario = Auth::user()->id;

            $id = InstrumentosRiasAPNAtnFamilias::on($this->cliente)->create([
                'irf_version' => $nuevaVersion,
                'irf_comentarios' => $request->irf_comentarios,
                'irf_instrumento' => json_encode($request->irf_instrumento),
                'irf_usu_creacion' => $usuario
            ])->irf_pk_id;

            HistoricoInsRiasAPNAtnFamilias::on($this->cliente)->create([
                'irf_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrf_accion' => 'Creación de una nueva versión del instrumento'
            ]);
        });

        return [$id, $nuevaVersion];
    }

    public function actualizarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            InstrumentosRiasAPNAtnFamilias::on($this->cliente)->where('irf_pk_id', $id)->update([
                'irf_comentarios' => $request->irf_comentarios,
                'irf_instrumento' => $request->irf_instrumento
            ]);

            HistoricoInsRiasAPNAtnFamilias::on($this->cliente)->create([
                'irf_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrf_accion' => 'Actualización del instrumento'
            ]);
        });
    }

    public function activarInstrumento(Request $request, $id) {
        DB::connection($this->cliente)->transaction(function() use($request, &$id) {
            $usuario = Auth::user()->id;

            $idActivo = InstrumentosRiasAPNAtnFamilias::on($this->cliente)
                                                    ->where('irf_activa', true)
                                                    ->pluck('irf_pk_id')[0];

            // Inactivar el actual
            InstrumentosRiasAPNAtnFamilias::on($this->cliente)->where('irf_pk_id', $idActivo)->update([
                'irf_activa' => false
            ]);

            HistoricoInsRiasAPNAtnFamilias::on($this->cliente)->create([
                'irf_fk_id' => $idActivo,
                'usu_fk_id' => $usuario,
                'hrf_accion' => 'El instrumento pasa a estado inactivo'
            ]);

            // Activar el nuevo instrumento
            InstrumentosRiasAPNAtnFamilias::on($this->cliente)->where('irf_pk_id', $id)->update([
                'irf_activa' => true
            ]);

            HistoricoInsRiasAPNAtnFamilias::on($this->cliente)->create([
                'irf_fk_id' => $id,
                'usu_fk_id' => $usuario,
                'hrf_accion' => 'El instrumento pasa a estado activo'
            ]);
        });
    }

    public function obtenerHistoricoVersion(Request $request, $id) {
        return HistoricoInsRiasAPNAtnFamilias::on($this->cliente)
                                   ->selectRaw('historico_ins_rias_apn_atn_familias.*, users.name')
                                   ->join('base.users', 'id', 'usu_fk_id')
                                   ->where('irf_fk_id', $id)
                                   ->orderBy('created_at', 'desc')
                                   ->get()->toArray();
    }
}
