<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;
use App\Models\clientes\ParametrosVerifica;

use App\Http\Services\DBClientConnection;

class ParametrosController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerModulosHabilitados() {
        return ParametrosVerifica::on($this->cliente)
                                 ->select('pav_mod_aud_calidad', 'pav_mod_pamec', 'pav_mod_rias', 'pav_mod_suh_3100')
                                 ->get()->toArray();
    }

    /*public function obtenerServiciosCliente(Request $request) {
        $cliente = Auth::user()->cli_fk_id;

        return Clientes::selectRaw("cli_numero_usuarios, cli_almacenamiento_nube, cli_mod_suh_3100, cli_mod_aud_calidad, cli_mod_rias, cli_mod_pamec")
                       ->where('cli_pk_id', $cliente)
                       ->get()->toArray();
    }*/
}
